
/*
 * $Id: hexdump.c,v 1.1 2003/11/10 15:04:05 jasper Exp $
 *
 * Pretty print a buffer with ASCII.
 *
 */

#include "hexdump.h"

void pretty_print_block(unsigned char *b, int len)
{
	int x, y, indent, count = 0;

	indent = 16; /* whatever */

	printf("\n");

	while (count < len)
	{
		printf("%04x : ", count);
		for (x = 0 ; x < indent ; x++)
		{
			printf("%02x ", b[x + count]);
			if ((x + count + 1) >= len)
			{
				x++;
				for (y = 0 ; y < (indent - x) ; y++)
					printf("   ");
				break;
			}
		}
		printf(": ");

		for (x = 0 ; x < indent ; x++)
		{
			if (isprint(b[x + count]))
				putchar(b[x + count]);
			else if (b[x + count] == 0)
				putchar(' ');
			else
				putchar('.');

			if ((x + count + 1) >= len)
			{
				x++;
				for (y = 0 ; y < (indent - x) ; y++)
					putchar(' ');
				break;
			}
		}
		putchar('\n');
		count += indent;
	}
	putchar('\n');
}

